#include <iostream>
#include <unordered_map>
#include <unordered_set>
#include <string> 
using namespace std;

int N, M, P, K;
long long memo[101][101][101];

int computeCurrentPrice(int x, int y, int z) {
	return (x * y * z + N + M + P) % K;
}

int determineShortestPath(int x, int y, int z) {
	if (x < 0 || y < 0 || z < 0) {
		return INT_MAX;
	}
	
	if (memo[x][y][z] != -1) {
		return memo[x][y][z];
	}

	auto opt1 = determineShortestPath(x - 1, y, z);
	auto opt2 = determineShortestPath(x, y - 1, z);
	auto opt3 = determineShortestPath(x, y, z - 1);
	int result= (min(opt1, min(opt2, opt3)) + computeCurrentPrice(x,y,z));
	memo[x][y][z] = result;
	return result;
}
int main()
{
	cin >> N >> M >> P >> K;
	for (int i = 0; i <=100 ; i++)
		for (int j = 0; j < 100; j++)
			for (int k = 0; k < 100; k++)
				memo[i][j][k] = -1;
	memo[0][0][0] = computeCurrentPrice(0, 0, 0);
	cout << determineShortestPath(N - 1, M - 1, P - 1);

}
